<?php
require_once 'includes/config.php';

// Optional page title (header currently uses SITE_NAME)
$pageTitle = 'Tentang Kami';

// Fetch simple stats for display
$stats = [
    'products' => 0,
    'categories' => 0,
    'users' => 0,
    'orders' => 0,
];

try {
    $conn = connectDB();

    $stmt = $conn->query("SELECT COUNT(*) AS total FROM products");
    $stats['products'] = (int) $stmt->fetchColumn();

    $stmt = $conn->query("SELECT COUNT(*) AS total FROM categories");
    $stats['categories'] = (int) $stmt->fetchColumn();

    $stmt = $conn->query("SELECT COUNT(*) AS total FROM users");
    $stats['users'] = (int) $stmt->fetchColumn();

    $stmt = $conn->query("SELECT COUNT(*) AS total FROM orders");
    $stats['orders'] = (int) $stmt->fetchColumn();
} catch (Throwable $e) {
    // Keep page working even if DB not ready
}

include 'includes/header.php';
?>

<section class="hero">
  <div class="container hero-content">
    <h2>Tentang <?php echo SITE_NAME; ?></h2>
    <p>Toko kelontong online yang menghadirkan kebutuhan harian Anda dengan harga terjangkau, kualitas terbaik, dan layanan yang bersahabat.</p>
    <a href="products/" class="btn"><i class="fas fa-shopping-bag"></i> Belanja Produk</a>
  </div>
  </section>

<div class="container about-page">
  <section class="about-intro about-intro-grid">
    <div class="about-card">
      <h3 style="margin-top:0;">Siapa Kami</h3>
      <p>
        <?php echo SITE_NAME; ?> adalah solusi belanja kebutuhan harian Anda. Kami menyediakan berbagai pilihan produk mulai dari makanan pokok, minuman, snack, hingga kebutuhan rumah tangga dan toiletries.
      </p>
      <p>
        Kami berkomitmen memberikan pengalaman belanja yang mudah, cepat, dan menyenangkan. Dengan proses pemesanan simpel dan pengiriman yang sigap, kebutuhan Anda akan sampai tepat waktu.
      </p>
      <div class="about-values">
        <div class="feature-card" style="padding:18px;">
          <div class="feature-icon"><i class="fas fa-truck"></i></div>
          <h4>Pengiriman Cepat</h4>
          <p>Pesanan diproses dengan sigap agar sampai tepat waktu.</p>
        </div>
        <div class="feature-card" style="padding:18px;">
          <div class="feature-icon"><i class="fas fa-medal"></i></div>
          <h4>Kualitas Terjamin</h4>
          <p>Produk pilihan dari merek terpercaya.</p>
        </div>
        <div class="feature-card" style="padding:18px;">
          <div class="feature-icon"><i class="fas fa-tag"></i></div>
          <h4>Harga Bersahabat</h4>
          <p>Penawaran menarik dan diskon berkala.</p>
        </div>
        <div class="feature-card" style="padding:18px;">
          <div class="feature-icon"><i class="fas fa-headset"></i></div>
          <h4>Dukungan Ramah</h4>
          <p>Siap membantu kapan pun Anda butuh.</p>
        </div>
      </div>
    </div>

    <aside class="about-stats">
      <h3 style="margin-top:0;">Sekilas Angka</h3>
      <div class="stat-list">
        <div class="stat-item">
          <span><i class="fas fa-box"></i> Produk</span>
          <strong><?php echo number_format($stats['products']); ?></strong>
        </div>
        <div class="stat-item">
          <span><i class="fas fa-tags"></i> Kategori</span>
          <strong><?php echo number_format($stats['categories']); ?></strong>
        </div>
        <div class="stat-item">
          <span><i class="fas fa-users"></i> Pengguna</span>
          <strong><?php echo number_format($stats['users']); ?></strong>
        </div>
        <div class="stat-item">
          <span><i class="fas fa-shopping-cart"></i> Pesanan</span>
          <strong><?php echo number_format($stats['orders']); ?></strong>
        </div>
      </div>
    </aside>
  </section>

  <section class="about-why" style="margin-top: 24px;">
    <div class="about-card">
      <h3 style="margin-top:0;">Mengapa Memilih Kami?</h3>
      <ul class="about-list">
        <li style="display:flex; gap:10px; align-items:flex-start;">
          <i class="fas fa-check-circle" style="color: var(--primary-color);"></i>
          <span>Transparan tanpa biaya tersembunyi.</span>
        </li>
        <li style="display:flex; gap:10px; align-items:flex-start;">
          <i class="fas fa-check-circle" style="color: var(--primary-color);"></i>
          <span>Produk selalu up-to-date dan stok jelas.</span>
        </li>
        <li style="display:flex; gap:10px; align-items:flex-start;">
          <i class="fas fa-check-circle" style="color: var(--primary-color);"></i>
          <span>Antarmuka sederhana, cepat, dan responsif.</span>
        </li>
        <li style="display:flex; gap:10px; align-items:flex-start;">
          <i class="fas fa-check-circle" style="color: var(--primary-color);"></i>
          <span>Dukungan pelanggan yang siap membantu.</span>
        </li>
      </ul>
    </div>
  </section>

  <section class="about-cta">
    <div class="about-cta-card">
      <h3>Ada pertanyaan atau butuh bantuan?</h3>
      <p class="muted">Tim kami siap membantu Anda memilih produk terbaik atau menyelesaikan kendala.</p>
      <a href="<?php echo SITE_URL; ?>contact.php" class="btn"><i class="fas fa-envelope"></i> Hubungi Kami</a>
    </div>
  </section>
</div>

<?php include 'includes/footer.php'; ?>


