<?php
require_once '../includes/config.php';

// Check if admin is logged in
if (!isAdminLoggedIn()) {
    redirect(SITE_URL . 'admin/login.php');
}

$pageTitle = "Logout";
include 'header.php';
?>

<div class="logout-page">
    <div class="logout-container">
        <h2>Logout Admin Panel</h2>
        <p>Apakah Anda yakin ingin keluar dari panel admin?</p>
        
        <div class="logout-buttons">
            <a href="logout.php" class="logout-btn">Ya, Logout</a>
            <a href="index.php" class="cancel-btn">Tidak, Kembali ke Dashboard</a>
        </div>
    </div>
</div>

<style>
    .logout-page {
        display: flex;
        justify-content: center;
        align-items: center;
        min-height: 400px;
    }
    
    .logout-container {
        background: white;
        border-radius: 5px;
        padding: 30px;
        box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        text-align: center;
        max-width: 500px;
        width: 100%;
    }
    
    .logout-container h2 {
        margin-bottom: 20px;
        color: #333;
    }
    
    .logout-container p {
        margin-bottom: 30px;
        font-size: 18px;
    }
    
    .logout-buttons {
        display: flex;
        justify-content: center;
        gap: 15px;
    }
    
    .logout-btn {
        display: inline-block;
        background-color: #e74c3c;
        color: white;
        padding: 12px 25px;
        border-radius: 4px;
        text-decoration: none;
        font-weight: bold;
        transition: background-color 0.3s;
    }
    
    .logout-btn:hover {
        background-color: #c0392b;
    }
    
    .cancel-btn {
        display: inline-block;
        background-color: #7f8c8d;
        color: white;
        padding: 12px 25px;
        border-radius: 4px;
        text-decoration: none;
        font-weight: bold;
        transition: background-color 0.3s;
    }
    
    .cancel-btn:hover {
        background-color: #636e72;
    }
</style>

<?php include 'footer.php'; ?> 