<?php
require_once 'includes/config.php';
$pageTitle = "Kontak";

$success = false;
$error = '';

// Process contact form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = sanitize($_POST['name']);
    $email = sanitize($_POST['email']);
    $subject = sanitize($_POST['subject']);
    $message = sanitize($_POST['message']);
    
    // Validate input
    if (empty($name) || empty($email) || empty($subject) || empty($message)) {
        $error = 'Semua field harus diisi';
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $error = 'Format email tidak valid';
    } else {
        // In a real implementation, send email or save message to database
        // For now, just show success message
        $success = true;
    }
}

include 'includes/header.php';
?>

<div class="contact-page">
    <div class="hero contact-hero">
        <div class="container hero-content">
            <h1>Hubungi Kami</h1>
            <p>Kami siap membantu Anda. Jangan ragu untuk menghubungi kami.</p>
        </div>
    </div>
    
    <div class="container contact-container">
        <div class="contact-info-section">
            <h2><i class="fas fa-info-circle"></i> Informasi Kontak</h2>
            
            <div class="contact-details">
                <div class="contact-item">
                    <i class="fas fa-map-marker-alt"></i>
                    <div>
                        <h3>Alamat</h3>
                        <p>Jalan Salak IV No.721 Blok A Bekasi Timur</p>
                    </div>
                </div>
                
                <div class="contact-item">
                    <i class="fas fa-phone"></i>
                    <div>
                        <h3>Telepon</h3>
                        <p>0813-8241-4663</p>
                    </div>
                </div>
                
                <div class="contact-item">
                    <i class="fas fa-envelope"></i>
                    <div>
                        <h3>Email</h3>
                        <p>rakhaakmal29@gmail.com</p>
                    </div>
                </div>
                
                <div class="contact-item">
                    <i class="fas fa-clock"></i>
                    <div>
                        <h3>Jam Operasional</h3>
                        <p>Senin - Minggu: 08.00 - 21.00</p>
                    </div>
                </div>
            </div>
            
            <div class="social-links">
                <h3>Ikuti Kami</h3>
                <div class="social-icons">
                    <a href="#" title="Facebook"><i class="fab fa-facebook-f"></i></a>
                    <a href="#" title="Instagram"><i class="fab fa-instagram"></i></a>
                    <a href="#" title="Twitter"><i class="fab fa-twitter"></i></a>
                    <a href="#" title="WhatsApp"><i class="fab fa-whatsapp"></i></a>
                </div>
            </div>
            
            <div class="contact-tips">
                <h3><i class="fas fa-lightbulb"></i> Tips Menghubungi Kami</h3>
                <ul>
                    <li>Sertakan nomor pesanan jika ada pertanyaan tentang pesanan Anda</li>
                    <li>Untuk pertanyaan produk, sertakan nama produk dengan jelas</li>
                    <li>Respons biasanya akan diberikan dalam 1x24 jam pada hari kerja</li>
                </ul>
            </div>
        </div>
        
        <div class="contact-form-section">
            <h2><i class="fas fa-paper-plane"></i> Kirim Pesan</h2>
            
            <?php if ($success): ?>
                <div class="success">
                    <i class="fas fa-check-circle"></i>
                    <p>Pesan Anda telah berhasil dikirim. Kami akan segera menghubungi Anda.</p>
                </div>
            <?php else: ?>
                <?php if (!empty($error)): ?>
                    <div class="error">
                        <i class="fas fa-exclamation-circle"></i>
                        <p><?php echo $error; ?></p>
                    </div>
                <?php endif; ?>
                
                <form action="contact.php" method="post" class="contact-form">
                    <div class="form-row">
                        <div class="form-group">
                            <label for="name"><i class="fas fa-user"></i> Nama Lengkap:</label>
                            <input type="text" id="name" name="name" placeholder="Masukkan nama lengkap" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="email"><i class="fas fa-envelope"></i> Email:</label>
                            <input type="email" id="email" name="email" placeholder="Masukkan email" required>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label for="subject"><i class="fas fa-tag"></i> Subjek:</label>
                        <input type="text" id="subject" name="subject" placeholder="Masukkan subjek pesan" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="message"><i class="fas fa-comment-alt"></i> Pesan:</label>
                        <textarea id="message" name="message" rows="6" placeholder="Tuliskan pesan Anda di sini..." required></textarea>
                    </div>
                    
                    <button type="submit" class="btn">
                        <i class="fas fa-paper-plane"></i> Kirim Pesan
                    </button>
                </form>
                
                <div class="contact-note">
                    <p><i class="fas fa-shield-alt"></i> Informasi Anda aman bersama kami dan tidak akan dibagikan kepada pihak lain.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
    
    <div class="map-section">
        <div class="container">
            <h2><i class="fas fa-map-marked-alt"></i> Lokasi Kami</h2>
            <div class="map-container">
            <!-- Using Google Maps iframe -->
            <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3966.2234839217517!2d107.0162318731675!3d-6.234244261047048!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x2e698e977c178737%3A0xec1135baef5f2165!2sJl.%20Salak%20IV%20A%20No.721%2C%20RT.015%2FRW.012%2C%20Duren%20Jaya%2C%20Kec.%20Bekasi%20Tim.%2C%20Kota%20Bks%2C%20Jawa%20Barat%2017111!5e0!3m2!1sid!2sid!4v1754825728238!5m2!1sid!2sid" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
            </div>
        </div>
    </div>
    
    <div class="faq-section">
        <div class="container">
            <h2><i class="fas fa-question-circle"></i> Pertanyaan Umum</h2>
            
            <div class="faq-container">
                <div class="faq-item">
                    <div class="faq-question">
                        <h3>Bagaimana cara melacak pesanan saya?</h3>
                        <span class="faq-toggle"><i class="fas fa-chevron-down"></i></span>
                    </div>
                    <div class="faq-answer">
                        <p>Anda dapat melacak pesanan Anda dengan masuk ke akun dan mengakses halaman "Pesanan Saya". Di sana Anda akan menemukan status terbaru dari setiap pesanan.</p>
                    </div>
                </div>
                
                <div class="faq-item">
                    <div class="faq-question">
                        <h3>Berapa lama waktu pengiriman?</h3>
                        <span class="faq-toggle"><i class="fas fa-chevron-down"></i></span>
                    </div>
                    <div class="faq-answer">
                        <p>Waktu pengiriman biasanya 1-3 hari kerja untuk wilayah Jakarta dan sekitarnya. Untuk wilayah lain, waktu pengiriman berkisar antara 3-7 hari kerja tergantung lokasi.</p>
                    </div>
                </div>
                
                <div class="faq-item">
                    <div class="faq-question">
                        <h3>Bagaimana kebijakan pengembalian barang?</h3>
                        <span class="faq-toggle"><i class="fas fa-chevron-down"></i></span>
                    </div>
                    <div class="faq-answer">
                        <p>Kami menerima pengembalian barang dalam waktu 7 hari setelah barang diterima, dengan syarat barang masih dalam kondisi utuh dan belum digunakan. Silakan hubungi tim layanan pelanggan kami untuk informasi lebih lanjut.</p>
                    </div>
                </div>
                
                <div class="faq-item">
                    <div class="faq-question">
                        <h3>Metode pembayaran apa saja yang tersedia?</h3>
                        <span class="faq-toggle"><i class="fas fa-chevron-down"></i></span>
                    </div>
                    <div class="faq-answer">
                        <p>Kami menerima pembayaran melalui transfer bank, e-wallet (OVO, GoPay, Dana), dan COD (Cash on Delivery) untuk beberapa wilayah tertentu.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // FAQ toggle functionality
    const faqItems = document.querySelectorAll('.faq-item');
    
    faqItems.forEach(item => {
        const question = item.querySelector('.faq-question');
        
        question.addEventListener('click', () => {
            // Close all other FAQs
            faqItems.forEach(otherItem => {
                if (otherItem !== item && otherItem.classList.contains('active')) {
                    otherItem.classList.remove('active');
                }
            });
            
            // Toggle active class on clicked item
            item.classList.toggle('active');
        });
    });
});
</script>

<?php include 'includes/footer.php'; ?> 