<?php
require_once '../includes/config.php';

try {
    // Connect to database
    $conn = connectDB();
    
    echo "<h1>Updating database structure...</h1>";
    
    // Add reset_token column if it doesn't exist
    $conn->exec("ALTER TABLE users ADD COLUMN IF NOT EXISTS reset_token VARCHAR(255) DEFAULT NULL");
    echo "Added or confirmed reset_token column to users table.<br>";
    
    // Add reset_expiry column if it doesn't exist
    $conn->exec("ALTER TABLE users ADD COLUMN IF NOT EXISTS reset_expiry DATETIME DEFAULT NULL");
    echo "Added or confirmed reset_expiry column to users table.<br>";
    
    // Add payment_proof column to orders table if it doesn't exist
    $conn->exec("ALTER TABLE orders ADD COLUMN IF NOT EXISTS payment_proof VARCHAR(255) DEFAULT NULL");
    echo "Added or confirmed payment_proof column to orders table.<br>";
    
    // Add shipping_method and payment_method columns to orders table if they don't exist
    $conn->exec("ALTER TABLE orders ADD COLUMN IF NOT EXISTS shipping_method VARCHAR(50) DEFAULT 'regular'");
    echo "Added or confirmed shipping_method column to orders table.<br>";

    $conn->exec("ALTER TABLE orders ADD COLUMN IF NOT EXISTS payment_method VARCHAR(50) DEFAULT 'transfer'");
    echo "Added or confirmed payment_method column to orders table.<br>";

    // Add payment_verified_at column to orders table if it doesn't exist
    $conn->exec("ALTER TABLE orders ADD COLUMN IF NOT EXISTS payment_verified_at DATETIME DEFAULT NULL");
    echo "Added or confirmed payment_verified_at column to orders table.<br>";

    // Add payment_rejected_at column to orders table if it doesn't exist
    $conn->exec("ALTER TABLE orders ADD COLUMN IF NOT EXISTS payment_rejected_at DATETIME DEFAULT NULL");
    echo "Added or confirmed payment_rejected_at column to orders table.<br>";

    // Add payment_notes column to orders table if it doesn't exist
    $conn->exec("ALTER TABLE orders ADD COLUMN IF NOT EXISTS payment_notes TEXT DEFAULT NULL");
    echo "Added or confirmed payment_notes column to orders table.<br>";
    
    echo "<br><strong>Database update completed successfully.</strong>";
    
} catch (PDOException $e) {
    echo "<h2>Error:</h2> " . $e->getMessage();
}
?> 