<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

if (session_status() !== PHP_SESSION_ACTIVE) {
    session_start();
}

date_default_timezone_set('Asia/Jakarta');

if (!defined('SITE_URL')) {
    define('SITE_URL', 'http://localhost/rakha/');
}

if (!defined('SITE_NAME')) {
    define('SITE_NAME', 'Warung Klontong Rakha');
}

if (!defined('DB_HOST')) {
    define('DB_HOST', 'localhost');
}
if (!defined('DB_NAME')) {
    define('DB_NAME', 'warung_klontong_rakha');
}
if (!defined('DB_USER')) {
    define('DB_USER', 'root');
}
if (!defined('DB_PASS')) {
    define('DB_PASS', '');
}

/**
 * Create and return a PDO connection to MySQL.
 *
 * @return PDO
 * @throws PDOException when connection fails
 */
function connectDB(): PDO {
    static $pdo = null;
    if ($pdo instanceof PDO) {
        return $pdo;
    }

    $dsn = 'mysql:host=' . DB_HOST . ';dbname=' . DB_NAME . ';charset=utf8mb4';
    $options = [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES => false,
    ];

    $pdo = new PDO($dsn, DB_USER, DB_PASS, $options);
    return $pdo;
}

// ----------------------------------------------------------------------------
// Helpers
// ----------------------------------------------------------------------------

/**
 * Trim string and optionally escape for safe HTML output.
 * Use for preparing values for storage or output.
 */
function sanitize(string $value, bool $escapeForHtml = false): string {
    $trimmed = trim($value);
    return $escapeForHtml ? htmlspecialchars($trimmed, ENT_QUOTES, 'UTF-8') : $trimmed;
}

/**
 * Redirect and stop further execution.
 */
function redirect(string $url): void {
    header('Location: ' . $url);
    exit;
}

/**
 * Check if a regular user is logged in.
 */
function isUserLoggedIn(): bool {
    return isset($_SESSION['user_id']) && is_numeric($_SESSION['user_id']);
}

/**
 * Check if an admin user is logged in.
 */
function isAdminLoggedIn(): bool {
    return isset($_SESSION['admin_id']) && is_numeric($_SESSION['admin_id']);
}

/**
 * Convenience accessors (not widely used but helpful).
 */
function currentUserId(): ?int {
    return isUserLoggedIn() ? (int) $_SESSION['user_id'] : null;
}

function currentAdminId(): ?int {
    return isAdminLoggedIn() ? (int) $_SESSION['admin_id'] : null;
}

// ----------------------------------------------------------------------------
// Email (PHPMailer) configuration
// ----------------------------------------------------------------------------

if (!defined('MAIL_HOST')) {
    define('MAIL_HOST', 'smtp.gmail.com'); // Your SMTP server
}
if (!defined('MAIL_USERNAME')) {
    define('MAIL_USERNAME', 'fatihuldanyy@gmail.com'); // Your SMTP username
}
if (!defined('MAIL_PASSWORD')) {
    define('MAIL_PASSWORD', 'whigcxtlxiskmnxa'); // Your SMTP password
}
if (!defined('MAIL_PORT')) {
    define('MAIL_PORT', 587); // Typically 587 for TLS, 465 for SSL
}
if (!defined('MAIL_SENDER_EMAIL')) {
    define('MAIL_SENDER_EMAIL', 'fatihuldanyy@gmail.com'); // Email address for sending
}
if (!defined('MAIL_SENDER_NAME')) {
    define('MAIL_SENDER_NAME', SITE_NAME); // Name associated with the sender email
}
// Set to true in development to see email content on screen (like the reset link)
// Set to false in production to send real emails
if (!defined('DEVELOPMENT')) {
    define('DEVELOPMENT', true);
}


