<?php 
require_once __DIR__ . '/config.php';

// Function to get cart item count
function getCartItemCount() {
    if (!isset($_SESSION['cart']) || empty($_SESSION['cart'])) {
        return 0;
    }
    
    $count = 0;
    foreach ($_SESSION['cart'] as $quantity) {
        // Cart items are stored directly as quantities
        $count += $quantity;
    }
    
    return $count;
}

$cartItemCount = 0;
if (isUserLoggedIn()) {
    $cartItemCount = getCartItemCount();
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo SITE_NAME; ?></title>
    <link rel="stylesheet" href="<?php echo SITE_URL; ?>assets/css/style.css">
    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <header>
        <div class="container">
            <div class="logo">
                <h1><a href="<?php echo SITE_URL; ?>"><?php echo SITE_NAME; ?></a></h1>
            </div>
            <nav>
                <ul>
                    <li><a href="<?php echo SITE_URL; ?>">Beranda</a></li>
                    <li><a href="<?php echo SITE_URL; ?>products/">Produk</a></li>
                    <li><a href="<?php echo SITE_URL; ?>about.php">Tentang Kami</a></li>
                    <li><a href="<?php echo SITE_URL; ?>contact.php">Kontak</a></li>
                </ul>
            </nav>
            <div class="user-actions">
                <?php if (isUserLoggedIn()): ?>
                    <a href="<?php echo SITE_URL; ?>cart/" class="cart-icon" title="Keranjang Belanja">
                        <i class="fas fa-shopping-cart"></i>
                        <?php if ($cartItemCount > 0): ?>
                            <span class="cart-count"><?php echo $cartItemCount; ?></span>
                        <?php endif; ?>
                    </a>
                    <div class="dropdown">
                        <button id="profileDropdownBtn" class="dropbtn" title="Profil Pengguna">
                            <i class="fas fa-user"></i>
                        </button>
                        <div id="profileDropdown" class="dropdown-content">
                            <a href="<?php echo SITE_URL; ?>user/profile.php">
                                <i class="fas fa-user-circle"></i> Profil
                            </a>
                            <a href="<?php echo SITE_URL; ?>user/orders.php">
                                <i class="fas fa-shopping-bag"></i> Pesanan
                            </a>
                            <a href="<?php echo SITE_URL; ?>user/logout.php">
                                <i class="fas fa-sign-out-alt"></i> Keluar
                            </a>
                        </div>
                    </div>
                <?php else: ?>
                    <a href="<?php echo SITE_URL; ?>user/login.php" class="login-btn">Masuk</a>
                    <a href="<?php echo SITE_URL; ?>user/register.php" class="register-btn">Daftar</a>
                <?php endif; ?>
            </div>
        </div>
    </header>
    <main>
        <div class="container"><?php // Container will be closed in footer.php ?>

<?php // Remove JavaScript from here as we'll move it to the footer ?> 