<?php
require_once 'includes/config.php';
$pageTitle = "Beranda";
include 'includes/header.php';

// Get featured products
try {
    $conn = connectDB();
    $stmt = $conn->prepare("SELECT p.*, c.name as category_name FROM products p 
                            LEFT JOIN categories c ON p.category_id = c.category_id 
                            ORDER BY p.created_at DESC LIMIT 8");
    $stmt->execute();
    $featuredProducts = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Get total products count
    $stmt = $conn->prepare("SELECT COUNT(*) as count FROM products");
    $stmt->execute();
    $totalProducts = $stmt->fetch(PDO::FETCH_ASSOC)['count'];
} catch (PDOException $e) {
    $error = "Terjadi kesalahan: " . $e->getMessage();
}
?>

<div class="hero">
    <div class="hero-content">
        <h2>Selamat Datang di <?php echo SITE_NAME; ?></h2>
        <p>Temukan kebutuhan harian Anda dengan harga terjangkau dan kualitas terbaik.</p>
        <a href="products/" class="btn"><i class="fas fa-shopping-cart"></i> Belanja Sekarang</a>
    </div>
</div>

<div class="container">
    <section class="categories-section">
        <h2>Kategori Produk</h2>
        <div class="categories">
            <?php
            try {
                $stmt = $conn->prepare("SELECT * FROM categories");
                $stmt->execute();
                $categories = $stmt->fetchAll(PDO::FETCH_ASSOC);
                
                // Array of category icons (Font Awesome)
                $categoryIcons = [
                    'Makanan Pokok' => 'fa-utensils',
                    'Minuman' => 'fa-coffee',
                    'Snack' => 'fa-cookie',
                    'Kebutuhan Rumah Tangga' => 'fa-home',
                    'Toiletries' => 'fa-soap'
                ];
                
                foreach ($categories as $category) {
                    // Get a default icon if category name doesn't match
                    $icon = $categoryIcons[$category['name']] ?? 'fa-box';
                    
                    echo '<div class="category-card">';
                    echo '<a href="products/?category=' . $category['category_id'] . '">';
                    echo '<div class="category-name"><i class="fas ' . $icon . '"></i><br>' . $category['name'] . '</div>';
                    echo '</a>';
                    echo '</div>';
                }
            } catch (PDOException $e) {
                echo '<p>Terjadi kesalahan saat memuat kategori</p>';
            }
            ?>
        </div>
    </section>

    <section class="featured-products">
        <h2>Produk Terbaru</h2>
        <div class="product-counter">
            <span>Tersedia <?php echo $totalProducts; ?> produk berkualitas untuk Anda</span>
        </div>
        
        <?php if (isset($error)): ?>
            <div class="error"><i class="fas fa-exclamation-circle"></i> <?php echo $error; ?></div>
        <?php else: ?>
            <div class="products">
                <?php foreach ($featuredProducts as $product): ?>
                    <div class="product-card">
                        <div class="product-img">
                            <?php if ($product['image_path']): ?>
                                <img src="<?php echo SITE_URL . $product['image_path']; ?>" alt="<?php echo $product['name']; ?>">
                            <?php else: ?>
                                <img src="<?php echo SITE_URL; ?>assets/img/no-image.jpg" alt="No Image">
                            <?php endif; ?>
                            <?php if ($product['stock'] == 0): ?>
                                <div class="product-badge out-of-stock">Stok Habis</div>
                            <?php elseif ($product['stock'] > 0 && $product['stock'] <= 5): ?>
                                <div class="product-badge limited-stock">Stok Terbatas</div>
                            <?php endif; ?>
                        </div>
                        <div class="product-info">
                            <h3><?php echo $product['name']; ?></h3>
                            <div class="category">
                                <i class="fas fa-tag"></i> <?php echo $product['category_name']; ?>
                            </div>
                            <div class="price">Rp <?php echo number_format($product['price'], 0, ',', '.'); ?></div>
                            <a href="products/detail.php?id=<?php echo $product['product_id']; ?>" class="btn">
                                <i class="fas fa-eye"></i> Detail
                            </a>
                            <?php if ($product['stock'] > 0): ?>
                                <button class="add-to-cart btn" data-id="<?php echo $product['product_id']; ?>">
                                    <i class="fas fa-cart-plus"></i> Tambah ke Keranjang
                                </button>
                            <?php else: ?>
                                <button class="btn" disabled>
                                    <i class="fas fa-times-circle"></i> Stok Habis
                                </button>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
        <div class="view-all">
            <a href="products/" class="btn">
                <i class="fas fa-th-list"></i> Lihat Semua Produk
            </a>
        </div>
    </section>

    <section class="promo-section">
        <div class="promo-content">
            <h2>Belanja Lebih Mudah dengan <?php echo SITE_NAME; ?></h2>
            <div class="feature-cards">
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-truck"></i>
                    </div>
                    <h3>Pengiriman Cepat</h3>
                    <p>Pesanan sampai di hari yang sama</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-medal"></i>
                    </div>
                    <h3>Kualitas Terbaik</h3>
                    <p>Produk pilihan berkualitas</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-tag"></i>
                    </div>
                    <h3>Harga Terjangkau</h3>
                    <p>Diskon menarik setiap hari</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-headset"></i>
                    </div>
                    <h3>Layanan Pelanggan</h3>
                    <p>Dukungan 24/7 untuk Anda</p>
                </div>
            </div>
        </div>
    </section>
    
    <section class="testimonials">
        <h2>Apa Kata Mereka</h2>
        <div class="testimonial-container">
            <div class="testimonial">
                <div class="testimonial-content">
                    <div class="quote"><i class="fas fa-quote-left"></i></div>
                    <p>Produk berkualitas dengan harga yang sangat terjangkau. Saya sudah berlangganan selama 3 bulan dan sangat puas dengan pelayanannya.</p>
                </div>
                <div class="testimonial-author">
                    <div class="author-avatar">
                        <i class="fas fa-user"></i>
                    </div>
                    <div class="author-info">
                        <h4>Ahmad Zaki</h4>
                        <div class="stars">
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="testimonial">
                <div class="testimonial-content">
                    <div class="quote"><i class="fas fa-quote-left"></i></div>
                    <p>Pengiriman cepat dan barang selalu datang dalam kondisi baik. Saya sangat merekomendasikan toko ini untuk kebutuhan sehari-hari.</p>
                </div>
                <div class="testimonial-author">
                    <div class="author-avatar">
                        <i class="fas fa-user"></i>
                    </div>
                    <div class="author-info">
                        <h4>Siti Rahma</h4>
                        <div class="stars">
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star-half-alt"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="testimonial">
                <div class="testimonial-content">
                    <div class="quote"><i class="fas fa-quote-left"></i></div>
                    <p>Pelayanan sangat ramah dan produk selalu fresh. Sudah 6 bulan saya belanja kebutuhan dapur disini dan tidak pernah mengecewakan.</p>
                </div>
                <div class="testimonial-author">
                    <div class="author-avatar">
                        <i class="fas fa-user"></i>
                    </div>
                    <div class="author-info">
                        <h4>Budi Santoso</h4>
                        <div class="stars">
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>



<?php include 'includes/footer.php'; ?> 