<?php
require_once 'includes/config.php';

// Test user details
$username = 'testuser';
$password = 'password123';
$name = 'Test User';
$email = 'testuser@example.com';
$address = 'Test Address, City, Country';
$phone = '1234567890';

// Hash the password
$hashedPassword = password_hash($password, PASSWORD_DEFAULT);

try {
    $conn = connectDB();
    
    // Check if user already exists
    $stmt = $conn->prepare("SELECT user_id FROM users WHERE username = :username OR email = :email");
    $stmt->bindParam(':username', $username);
    $stmt->bindParam(':email', $email);
    $stmt->execute();
    
    if ($stmt->rowCount() > 0) {
        echo "<p>User already exists!</p>";
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        echo "<p>User ID: " . $user['user_id'] . "</p>";
    } else {
        // Insert new user
        $stmt = $conn->prepare("INSERT INTO users (username, password, name, email, address, phone) 
                              VALUES (:username, :password, :name, :email, :address, :phone)");
        $stmt->bindParam(':username', $username);
        $stmt->bindParam(':password', $hashedPassword);
        $stmt->bindParam(':name', $name);
        $stmt->bindParam(':email', $email);
        $stmt->bindParam(':address', $address);
        $stmt->bindParam(':phone', $phone);
        
        if ($stmt->execute()) {
            $userId = $conn->lastInsertId();
            echo "<p>Test user created successfully!</p>";
            echo "<p>User ID: $userId</p>";
            echo "<p>Username: $username</p>";
            echo "<p>Password: $password</p>";
        } else {
            echo "<p>Error creating user.</p>";
        }
    }
} catch (PDOException $e) {
    echo "<p>Database Error: " . $e->getMessage() . "</p>";
}
?> 