<?php
require_once '../includes/config.php';

// Get product ID
$product_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($product_id <= 0) {
    redirect(SITE_URL . 'products/');
}

try {
    $conn = connectDB();
    
    // Get product details
    $stmt = $conn->prepare("SELECT p.*, c.name as category_name FROM products p 
                           LEFT JOIN categories c ON p.category_id = c.category_id 
                           WHERE p.product_id = :product_id");
    $stmt->bindParam(':product_id', $product_id);
    $stmt->execute();
    
    if ($product = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $pageTitle = $product['name'];
        
        // Get related products from same category
        $stmt = $conn->prepare("SELECT p.* FROM products p 
                               WHERE p.category_id = :category_id AND p.product_id != :product_id 
                               ORDER BY p.created_at DESC LIMIT 4");
        $stmt->bindParam(':category_id', $product['category_id']);
        $stmt->bindParam(':product_id', $product_id);
        $stmt->execute();
        $relatedProducts = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        // Array of category icons (Font Awesome)
        $categoryIcons = [
            'Makanan Pokok' => 'fa-utensils',
            'Minuman' => 'fa-coffee',
            'Snack' => 'fa-cookie',
            'Kebutuhan Rumah Tangga' => 'fa-home',
            'Toiletries' => 'fa-soap'
        ];
        
        $categoryIcon = $categoryIcons[$product['category_name']] ?? 'fa-tag';
    } else {
        redirect(SITE_URL . 'products/');
    }
} catch (PDOException $e) {
    $error = "Error: " . $e->getMessage();
}

include '../includes/header.php';
?>

<div class="container">
    <div class="product-detail">
        <div class="breadcrumb">
            <a href="<?php echo SITE_URL; ?>"><i class="fas fa-home"></i> Beranda</a> &gt; 
            <a href="<?php echo SITE_URL; ?>products/"><i class="fas fa-shopping-basket"></i> Produk</a> &gt; 
            <?php if (isset($product['category_id'])): ?>
            <a href="<?php echo SITE_URL; ?>products/?category=<?php echo $product['category_id']; ?>">
                <i class="fas <?php echo $categoryIcon; ?>"></i> <?php echo $product['category_name']; ?>
            </a> &gt; 
            <?php endif; ?>
            <span><?php echo $product['name']; ?></span>
        </div>
        
        <?php if (isset($error)): ?>
            <div class="error">
                <i class="fas fa-exclamation-circle"></i> <?php echo $error; ?>
            </div>
        <?php else: ?>
            <div class="product-container">
                <div class="product-image">
                    <?php if ($product['image_path']): ?>
                        <div class="image-container">
                            <img src="<?php echo SITE_URL . $product['image_path']; ?>" alt="<?php echo $product['name']; ?>">
                            <?php if ($product['stock'] <= 5 && $product['stock'] > 0): ?>
                                <div class="product-badge">Stok Terbatas</div>
                            <?php elseif ($product['stock'] <= 0): ?>
                                <div class="product-badge" style="background-color: #f44336;">Stok Habis</div>
                            <?php endif; ?>
                        </div>
                    <?php else: ?>
                        <div class="image-container">
                            <img src="<?php echo SITE_URL; ?>assets/img/no-image.jpg" alt="No Image">
                            <?php if ($product['stock'] <= 5 && $product['stock'] > 0): ?>
                                <div class="product-badge">Stok Terbatas</div>
                            <?php elseif ($product['stock'] <= 0): ?>
                                <div class="product-badge" style="background-color: #f44336;">Stok Habis</div>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
                
                <div class="product-info-detail">
                    <h1><?php echo $product['name']; ?></h1>
                    
                    <div class="category">
                        <i class="fas <?php echo $categoryIcon; ?>"></i> 
                        Kategori: <a href="<?php echo SITE_URL; ?>products/?category=<?php echo $product['category_id']; ?>">
                            <?php echo $product['category_name']; ?>
                        </a>
                    </div>
                    
                    <div class="price">Rp <?php echo number_format($product['price'], 0, ',', '.'); ?></div>
                    
                    <div class="stock-info">
                        <?php if ($product['stock'] > 0): ?>
                            <span class="in-stock">Stok Tersedia (<?php echo $product['stock']; ?>)</span>
                        <?php else: ?>
                            <span class="out-of-stock">Stok Habis</span>
                        <?php endif; ?>
                    </div>
                    
                    <?php if ($product['stock'] > 0): ?>
                        <div class="add-to-cart-form">
                            <div class="quantity">
                                <label for="quantity">Jumlah:</label>
                                <div class="quantity-selector">
                                    <button type="button" class="quantity-btn minus" onclick="updateQuantity(-1)">
                                        <i class="fas fa-minus"></i>
                                    </button>
                                    <input type="number" id="quantity" name="quantity" value="1" min="1" max="<?php echo $product['stock']; ?>" readonly>
                                    <button type="button" class="quantity-btn plus" onclick="updateQuantity(1)">
                                        <i class="fas fa-plus"></i>
                                    </button>
                                </div>
                            </div>
                            <button type="button" class="add-to-cart btn" data-id="<?php echo $product['product_id']; ?>">
                                <i class="fas fa-cart-plus"></i> Tambah ke Keranjang
                            </button>
                        </div>
                    <?php endif; ?>
                    
                    <div class="product-description">
                        <h3><i class="fas fa-info-circle"></i> Deskripsi</h3>
                        <?php if (!empty($product['description'])): ?>
                            <p><?php echo nl2br($product['description']); ?></p>
                        <?php else: ?>
                            <p class="no-description">Tidak ada deskripsi produk.</p>
                        <?php endif; ?>
                    </div>
                    
                    <div class="product-features">
                        <div class="feature">
                            <i class="fas fa-shipping-fast"></i>
                            <span>Pengiriman Cepat</span>
                        </div>
                        <div class="feature">
                            <i class="fas fa-redo"></i>
                            <span>Garansi 7 Hari</span>
                        </div>
                        <div class="feature">
                            <i class="fas fa-shield-alt"></i>
                            <span>Produk Asli</span>
                        </div>
                    </div>
                </div>
            </div>
            
            <?php if (!empty($relatedProducts)): ?>
                <div class="container">
                    <div class="related-products">
                        <h2>Produk Terkait</h2>
                        <div class="products">
                            <?php foreach ($relatedProducts as $relatedProduct): ?>
                                <div class="product-card">
                                    <div class="product-img">
                                        <?php if ($relatedProduct['image_path']): ?>
                                            <div class="image-container related-image">
                                                <img src="<?php echo SITE_URL . $relatedProduct['image_path']; ?>" alt="<?php echo $relatedProduct['name']; ?>">
                                                <?php if ($relatedProduct['stock'] <= 5 && $relatedProduct['stock'] > 0): ?>
                                                    <div class="product-badge">Stok Terbatas</div>
                                                <?php elseif ($relatedProduct['stock'] <= 0): ?>
                                                    <div class="product-badge" style="background-color: #f44336;">Stok Habis</div>
                                                <?php endif; ?>
                                            </div>
                                        <?php else: ?>
                                            <div class="image-container related-image">
                                                <img src="<?php echo SITE_URL; ?>assets/img/no-image.jpg" alt="No Image">
                                                <?php if ($relatedProduct['stock'] <= 5 && $relatedProduct['stock'] > 0): ?>
                                                    <div class="product-badge">Stok Terbatas</div>
                                                <?php elseif ($relatedProduct['stock'] <= 0): ?>
                                                    <div class="product-badge" style="background-color: #f44336;">Stok Habis</div>
                                                <?php endif; ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="product-info">
                                        <h3><?php echo $relatedProduct['name']; ?></h3>
                                        <div class="price">Rp <?php echo number_format($relatedProduct['price'], 0, ',', '.'); ?></div>
                                        <a href="detail.php?id=<?php echo $relatedProduct['product_id']; ?>" class="btn">
                                            <i class="fas fa-eye"></i> Detail
                                        </a>
                                        <?php if ($relatedProduct['stock'] > 0): ?>
                                            <button class="add-to-cart btn" data-id="<?php echo $relatedProduct['product_id']; ?>">
                                                <i class="fas fa-cart-plus"></i> Tambah ke Keranjang
                                            </button>
                                        <?php else: ?>
                                            <button class="btn" disabled>
                                                <i class="fas fa-times-circle"></i> Stok Habis
                                            </button>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</div>

<?php include '../includes/footer.php'; ?> 