<?php
require_once 'includes/config.php';
$pageTitle = "Syarat & Ketentuan";
include 'includes/header.php';
?>

<div class="container">
    <div class="terms-page">
        <h1>Syarat dan Ketentuan</h1>
        
        <div class="terms-content">
            <section class="terms-section">
                <h2>1. Umum</h2>
                <p>Selamat datang di <?php echo SITE_NAME; ?>. Dengan mengakses dan menggunakan website ini, Anda menyetujui syarat dan ketentuan yang berlaku. Silakan baca dengan seksama sebelum melakukan pembelian atau menggunakan layanan kami.</p>
            </section>
            
            <section class="terms-section">
                <h2>2. Definisi</h2>
                <ul>
                    <li>"Website" mengacu pada <?php echo SITE_NAME; ?>, termasuk semua konten dan fungsionalitasnya.</li>
                    <li>"Pengguna" adalah individu yang mengakses dan menggunakan website ini.</li>
                    <li>"Produk" adalah barang yang dijual melalui website ini.</li>
                    <li>"Pesanan" adalah permintaan pembelian produk dari pengguna.</li>
                </ul>
            </section>
            
            <section class="terms-section">
                <h2>3. Akun Pengguna</h2>
                <p>Untuk melakukan pembelian, Anda harus membuat akun pengguna. Anda bertanggung jawab untuk menjaga kerahasiaan akun dan kata sandi Anda. Anda juga bertanggung jawab atas semua aktivitas yang terjadi di bawah akun Anda.</p>
            </section>
            
            <section class="terms-section">
                <h2>4. Pemesanan dan Pembayaran</h2>
                <ul>
                    <li>Harga produk yang tercantum adalah dalam Rupiah (IDR) dan sudah termasuk pajak.</li>
                    <li>Kami berhak untuk mengubah harga produk tanpa pemberitahuan terlebih dahulu.</li>
                    <li>Pembayaran dapat dilakukan melalui metode yang tersedia di website.</li>
                    <li>Pesanan hanya akan diproses setelah pembayaran dikonfirmasi.</li>
                </ul>
            </section>
            
            <section class="terms-section">
                <h2>5. Pengiriman</h2>
                <ul>
                    <li>Pengiriman dilakukan ke alamat yang diberikan saat pemesanan.</li>
                    <li>Waktu pengiriman dapat bervariasi tergantung lokasi dan metode pengiriman yang dipilih.</li>
                    <li>Biaya pengiriman ditanggung oleh pembeli.</li>
                </ul>
            </section>
            
            <section class="terms-section">
                <h2>6. Pengembalian dan Refund</h2>
                <ul>
                    <li>Pengembalian produk dapat dilakukan dalam waktu 7 hari setelah penerimaan.</li>
                    <li>Produk harus dalam kondisi asli, belum dibuka, dan dengan kemasan lengkap.</li>
                    <li>Biaya pengiriman untuk pengembalian ditanggung oleh pembeli.</li>
                    <li>Refund akan diproses dalam waktu 7-14 hari kerja setelah produk diterima dan diperiksa.</li>
                </ul>
            </section>
            
            <section class="terms-section">
                <h2>7. Hak Kekayaan Intelektual</h2>
                <p>Semua konten di website ini, termasuk tetapi tidak terbatas pada teks, grafik, logo, ikon, gambar, klip audio, unduhan digital, dan kompilasi data, adalah milik <?php echo SITE_NAME; ?> dan dilindungi oleh hukum hak cipta.</p>
            </section>
            
            <section class="terms-section">
                <h2>8. Batasan Tanggung Jawab</h2>
                <p><?php echo SITE_NAME; ?> tidak bertanggung jawab atas kerugian atau kerusakan yang timbul dari penggunaan atau ketidakmampuan untuk menggunakan website ini atau kontennya.</p>
            </section>
            
            <section class="terms-section">
                <h2>9. Perubahan Syarat dan Ketentuan</h2>
                <p>Kami berhak untuk mengubah syarat dan ketentuan ini kapan saja. Perubahan akan berlaku segera setelah diposting di website. Penggunaan berkelanjutan dari website setelah perubahan tersebut merupakan persetujuan Anda terhadap syarat dan ketentuan yang diperbarui.</p>
            </section>
            
            <section class="terms-section">
                <h2>10. Kontak</h2>
                <p>Jika Anda memiliki pertanyaan tentang syarat dan ketentuan ini, silakan hubungi kami melalui halaman <a href="contact.php">Kontak</a> atau melalui email di info@warungrakha.com.</p>
            </section>
        </div>
        
        <div class="terms-footer">
            <p>Terakhir diperbarui: <?php echo date('d F Y'); ?></p>
        </div>
    </div>
</div>

<style>
.terms-page {
    padding: 30px 0;
    max-width: 900px;
    margin: 0 auto;
}

.terms-page h1 {
    color: var(--primary-color);
    margin-bottom: 30px;
    padding-bottom: 15px;
    border-bottom: 1px solid var(--border-color);
}

.terms-content {
    background-color: var(--white);
    border-radius: 8px;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
    padding: 30px;
}

.terms-section {
    margin-bottom: 30px;
}

.terms-section h2 {
    color: var(--text-color);
    font-size: 1.4rem;
    margin-bottom: 15px;
    font-weight: 600;
}

.terms-section p, .terms-section ul {
    line-height: 1.6;
    color: var(--dark-gray);
    margin-bottom: 15px;
}

.terms-section ul {
    list-style-type: disc;
    padding-left: 20px;
}

.terms-section ul li {
    margin-bottom: 8px;
}

.terms-footer {
    text-align: right;
    margin-top: 20px;
    color: var(--dark-gray);
    font-style: italic;
    font-size: 0.9rem;
}

@media (max-width: 768px) {
    .terms-content {
        padding: 20px;
    }
    
    .terms-section h2 {
        font-size: 1.2rem;
    }
}
</style>

<?php include 'includes/footer.php'; ?> 