<?php
require_once '../includes/config.php';
$pageTitle = "Pesanan Saya";

// Check if user is logged in
if (!isUserLoggedIn()) {
    redirect(SITE_URL . 'user/login.php');
}

$user_id = $_SESSION['user_id'];

try {
    $conn = connectDB();
    
    // Get user information
    $stmt = $conn->prepare("SELECT * FROM users WHERE user_id = :user_id");
    $stmt->bindParam(':user_id', $user_id);
    $stmt->execute();
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // Get user orders
    $stmt = $conn->prepare("SELECT * FROM orders WHERE user_id = :user_id ORDER BY created_at DESC");
    $stmt->bindParam(':user_id', $user_id);
    $stmt->execute();
    $orders = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
} catch (PDOException $e) {
    $error = "Error: " . $e->getMessage();
}

include '../includes/header.php';
?>

<div class="profile-page">
    <div class="container">
        <h1>Pesanan Saya</h1>
        
        <?php if (isset($error)): ?>
            <div class="error">
                <i class="fas fa-exclamation-circle"></i> <?php echo $error; ?>
            </div>
        <?php endif; ?>
        
        <div class="profile-container">
            <div class="profile-sidebar">
                <div class="profile-menu">
                    <div class="profile-header">
                        <div class="profile-avatar">
                            <i class="fas fa-user"></i>
                        </div>
                        <div class="profile-name">
                            <?php echo $user['name']; ?>
                        </div>
                        <div class="profile-email">
                            <?php echo $user['email']; ?>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="profile-content">
                <div class="profile-section">
                    <h2><i class="fas fa-shopping-bag"></i> Riwayat Pesanan</h2>
                    
                    <?php if (empty($orders)): ?>
                        <div class="empty-orders">
                            <div class="empty-orders-icon">
                                <i class="fas fa-shopping-cart"></i>
                            </div>
                            <p>Anda belum memiliki pesanan.</p>
                            <a href="<?php echo SITE_URL; ?>products/" class="btn">
                                <i class="fas fa-shopping-cart"></i> Belanja Sekarang
                            </a>
                        </div>
                    <?php else: ?>
                        <div class="orders-list">
                            <div class="table-responsive">
                                <table class="orders-table">
                                    <thead>
                                        <tr>
                                            <th>ID Pesanan</th>
                                            <th>Tanggal</th>
                                            <th>Total</th>
                                            <th>Status</th>
                                            <th>Aksi</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($orders as $order): ?>
                                            <tr>
                                                <td>#<?php echo $order['order_id']; ?></td>
                                                <td><?php echo date('d-m-Y H:i', strtotime($order['created_at'])); ?></td>
                                                <td>Rp <?php echo number_format($order['total_amount'], 0, ',', '.'); ?></td>
                                                <td>
                                                    <span class="order-status status-<?php echo $order['status']; ?>">
                                                        <?php 
                                                        switch($order['status']) {
                                                            case 'pending': echo '<i class="fas fa-clock"></i> Menunggu Pembayaran'; break;
                                                            case 'processing': echo '<i class="fas fa-cog fa-spin"></i> Diproses'; break;
                                                            case 'shipped': echo '<i class="fas fa-truck"></i> Dikirim'; break;
                                                            case 'delivered': echo '<i class="fas fa-check-circle"></i> Terkirim'; break;
                                                            case 'cancelled': echo '<i class="fas fa-times-circle"></i> Dibatalkan'; break;
                                                            default: echo $order['status']; break;
                                                        }
                                                        ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <a href="order_detail.php?id=<?php echo $order['order_id']; ?>" class="btn btn-sm">
                                                        <i class="fas fa-eye"></i> Detail
                                                    </a>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .orders-table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 20px;
    }
    
    .orders-table th,
    .orders-table td {
        padding: 12px 15px;
        text-align: left;
        border-bottom: 1px solid var(--border-color);
    }
    
    .orders-table th {
        background-color: var(--light-gray);
        font-weight: 600;
    }
    
    .order-status {
        display: inline-block;
        padding: 6px 10px;
        border-radius: 20px;
        font-size: 14px;
        font-weight: 500;
    }
    
    .status-pending {
        background-color: #FFF3CD;
        color: #856404;
    }
    
    .status-processing {
        background-color: #D1ECF1;
        color: #0C5460;
    }
    
    .status-shipped {
        background-color: #D4EDDA;
        color: #155724;
    }
    
    .status-delivered {
        background-color: #D4EDDA;
        color: #155724;
    }
    
    .status-cancelled {
        background-color: #F8D7DA;
        color: #721C24;
    }
    
    .btn-sm {
        padding: 5px 10px;
        font-size: 14px;
    }
    
    .empty-orders {
        text-align: center;
        padding: 30px 0;
    }
    
    .empty-orders-icon {
        font-size: 60px;
        color: var(--light-gray);
        margin-bottom: 20px;
    }
    
    .empty-orders p {
        margin-bottom: 20px;
        color: var(--dark-gray);
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const deleteButtons = document.querySelectorAll('.delete-order-btn');
        deleteButtons.forEach(button => {
            button.addEventListener('click', function(e) {
                e.preventDefault();
                const orderId = this.dataset.orderId;
                // Use custom confirmation dialog instead of native confirm()
                showConfirmationDialog('Apakah Anda yakin ingin menghapus pesanan ini?', function() {
                    window.location.href = 'delete_order.php?id=' + orderId;
                });
            });
        });
    });
</script>

<?php include '../includes/footer.php'; ?> 