<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle ?? 'Admin Panel'; ?> - <?php echo SITE_NAME; ?></title>
    <link rel="stylesheet" href="<?php echo SITE_URL; ?>assets/css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        /* Additional Admin Panel Styling */
        .admin-container {
            display: flex;
            min-height: 100vh;
        }

        .admin-sidebar {
            width: 250px;
            background: var(--dark-gray);
            color: var(--white);
            height: 100vh;
            position: fixed;
            display: flex;
            flex-direction: column;
        }

        .admin-content {
            flex: 1;
            margin-left: 250px;
            padding: 20px;
        }

        .sidebar-header {
            padding: 20px;
            text-align: center;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .sidebar-header h2 {
            color: var(--white);
            margin: 0;
            font-size: 1.5rem;
        }

        .sidebar-menu {
            padding: 20px 0;
            flex-grow: 1;
        }

        .sidebar-menu ul {
            list-style: none;
            padding: 0;
            margin: 0;
        }

        .sidebar-menu li {
            margin-bottom: 5px;
        }

        .sidebar-menu a {
            display: block;
            padding: 10px 20px;
            color: rgba(255, 255, 255, 0.8);
            text-decoration: none;
            transition: all 0.3s;
            border-left: 3px solid transparent;
        }

        .sidebar-menu a:hover,
        .sidebar-menu a.active {
            background: rgba(255, 255, 255, 0.1);
            color: var(--white);
            border-left-color: var(--primary-color);
        }

        .sidebar-menu a i {
            margin-right: 10px;
            width: 20px;
            text-align: center;
        }
        
        /* Logout button styles */
        .logout-btn {
            display: block;
            background-color: #e74c3c;
            color: white !important;
            text-align: center;
            padding: 10px 20px !important;
            margin: 5px 0 !important;
            border-radius: 0 !important;
            text-decoration: none;
            font-weight: bold;
            transition: all 0.3s;
            border-left: 3px solid #c0392b !important;
        }
        
        .logout-btn:hover {
            background-color: #c0392b !important;
            color: white !important;
            transform: none !important;
            box-shadow: none !important;
        }
        
        .logout-btn i {
            margin-right: 10px;
        }
        
        /* Divider after users menu */
        .menu-divider {
            height: 1px;
            background-color: rgba(255,255,255,0.1);
            margin: 5px 15px;
        }

        /* Chart styles */
        .charts-container {
            margin-bottom: 30px;
        }
        
        .chart-section {
            margin-bottom: 20px;
        }
        
        .chart-card {
            background-color: white;
            border-radius: 5px;
            padding: 20px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        }
        
        .chart-container {
            position: relative;
            height: 300px;
            margin-top: 15px;
        }
        
        .chart-row {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(450px, 1fr));
            gap: 20px;
        }
        
        @media (max-width: 768px) {
            .chart-row {
                grid-template-columns: 1fr;
            }
            
            .chart-container {
                height: 250px;
            }
        }

        /* Form styles */
        .form-row {
            display: flex;
            flex-wrap: wrap;
            margin: -10px;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group.half {
            width: 50%;
            padding: 0 10px;
            box-sizing: border-box;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 5px;
            font-weight: 500;
        }
        
        .form-group input[type="text"],
        .form-group input[type="number"],
        .form-group input[type="email"],
        .form-group input[type="password"],
        .form-group select,
        .form-group textarea {
            width: 100%;
            padding: 8px 12px;
            border: 1px solid #ddd;
            border-radius: 4px;
            box-sizing: border-box;
            font-size: 14px;
        }
        
        .form-group textarea {
            min-height: 100px;
            resize: vertical;
        }
        
        .form-group small {
            display: block;
            margin-top: 5px;
            color: #666;
            font-size: 12px;
        }
        
        .form-group .required {
            color: #e74c3c;
        }
        
        .form-actions {
            margin-top: 30px;
            display: flex;
            gap: 10px;
        }
        
        .current-image {
            margin-bottom: 15px;
        }
        
        .current-image p {
            margin-bottom: 5px;
            font-weight: 500;
        }
        
        .success, .error {
            padding: 10px 15px;
            margin-bottom: 20px;
            border-radius: 5px;
        }
        
        .success {
            background-color: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        
        .error {
            background-color: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        
        .error ul {
            margin: 5px 0 0 20px;
            padding: 0;
        }
        
        @media (max-width: 768px) {
            .form-group.half {
                width: 100%;
            }
            
            .form-actions {
                flex-direction: column;
            }
        }

        .admin-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }

        .admin-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            background-color: white;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        }

        .admin-table th,
        .admin-table td {
            padding: 12px 15px;
            text-align: left;
            border-bottom: 1px solid #e0e0e0;
        }

        .admin-table th {
            background-color: #f5f5f5;
            font-weight: bold;
        }

        .admin-table tr:hover {
            background-color: #f9f9f9;
        }

        .action-btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 30px;
            height: 30px;
            border-radius: 50%;
            color: white;
            text-decoration: none;
            margin-right: 5px;
        }

        .view-btn {
            background-color: #3498db;
        }

        .edit-btn {
            background-color: #2ecc71;
        }

        .delete-btn {
            background-color: #e74c3c;
        }

        /* Dashboard stats */
        .dashboard-stats {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(220px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }

        .stat-card {
            background-color: white;
            border-radius: 5px;
            padding: 20px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
            display: flex;
            align-items: center;
        }

        .stat-icon {
            background-color: rgba(76, 175, 80, 0.1);
            color: var(--primary-color);
            width: 60px;
            height: 60px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
            margin-right: 15px;
        }

        .stat-info h3 {
            margin: 0;
            font-size: 16px;
            color: var(--dark-gray);
        }

        .stat-info p {
            margin: 5px 0 0;
            font-size: 20px;
            font-weight: bold;
            color: var(--text-color);
        }

        /* Status badges */
        .status-badge {
            display: inline-block;
            padding: 5px 10px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: bold;
        }

        .status-pending {
            background-color: #f39c12;
            color: white;
        }

        .status-processing {
            background-color: #3498db;
            color: white;
        }

        .status-shipped {
            background-color: #9b59b6;
            color: white;
        }

        .status-delivered {
            background-color: #2ecc71;
            color: white;
        }

        .status-cancelled {
            background-color: #e74c3c;
            color: white;
        }

        /* Dashboard sections */
        .dashboard-section {
            background-color: white;
            border-radius: 5px;
            padding: 20px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
            margin-bottom: 20px;
        }

        .dashboard-section h2 {
            margin-top: 0;
            margin-bottom: 20px;
            color: var(--text-color);
            font-size: 18px;
            border-bottom: 1px solid #e0e0e0;
            padding-bottom: 10px;
        }

        .view-all-link {
            text-align: right;
            margin-top: 10px;
        }

        .view-all-link a {
            color: var(--primary-color);
            text-decoration: none;
        }

        /* Quick actions */
        .quick-actions {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
            gap: 15px;
        }

        .quick-action-btn {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            background-color: white;
            border-radius: 5px;
            padding: 20px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
            text-decoration: none;
            color: var(--text-color);
            transition: transform 0.3s;
            text-align: center;
        }

        .quick-action-btn:hover {
            transform: translateY(-5px);
        }

        .quick-action-btn i {
            font-size: 24px;
            color: var(--primary-color);
            margin-bottom: 10px;
        }

        /* Forms */
        .admin-form {
            background-color: white;
            border-radius: 5px;
            padding: 20px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        }

        /* Admin content box */
        .admin-content-box {
            background-color: white;
            border-radius: 5px;
            padding: 20px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
            margin-bottom: 20px;
        }

        /* Pagination */
        .pagination {
            display: flex;
            justify-content: center;
            margin-top: 20px;
        }

        .page-link {
            padding: 8px 12px;
            margin: 0 5px;
            background-color: #f4f4f4;
            color: var(--text-color);
            text-decoration: none;
            border-radius: 4px;
        }

        .page-link.active {
            background-color: var(--primary-color);
            color: white;
        }

        .page-link:hover:not(.active) {
            background-color: #ddd;
        }

        /* Sidebar footer with logout */
        .sidebar-footer {
            padding: 15px 20px;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            margin-top: auto;
        }

        .admin-info {
            font-size: 14px;
            color: rgba(255, 255, 255, 0.7);
            margin-bottom: 15px;
        }

        /* Header logout button */
        .header-actions {
            display: flex;
            align-items: center;
        }

        .admin-name {
            margin-right: 15px;
            font-weight: 500;
        }
        
        .header-logout-btn {
            display: inline-block;
            background-color: #e74c3c;
            color: white;
            padding: 6px 12px;
            border-radius: 4px;
            text-decoration: none;
            font-size: 14px;
            font-weight: 500;
            transition: all 0.3s;
        }
        
        .header-logout-btn:hover {
            background-color: #c0392b;
            transform: translateY(-2px);
            box-shadow: 0 2px 5px rgba(0,0,0,0.2);
        }
        
        .header-logout-btn i {
            margin-right: 5px;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .admin-sidebar {
                width: 100%;
                height: auto;
                position: relative;
            }

            .admin-content {
                margin-left: 0;
            }

            .admin-container {
                flex-direction: column;
            }

            .dashboard-stats {
                grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
            }
        }
    </style>
</head>
<body>
    <div class="admin-container">
        <div class="admin-sidebar">
            <div class="sidebar-header">
                <h2><?php echo SITE_NAME; ?></h2>
                <p>Panel Admin</p>
            </div>
            <div class="sidebar-menu">
                <ul>
                    <li>
                        <a href="<?php echo SITE_URL; ?>admin/" class="<?php echo basename($_SERVER['PHP_SELF']) == 'index.php' && dirname($_SERVER['PHP_SELF']) == '/rakha/admin' ? 'active' : ''; ?>">
                            <i class="fas fa-tachometer-alt"></i> Dashboard
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo SITE_URL; ?>admin/products/" class="<?php echo strpos($_SERVER['PHP_SELF'], '/admin/products/') !== false ? 'active' : ''; ?>">
                            <i class="fas fa-box"></i> Produk
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo SITE_URL; ?>admin/categories/" class="<?php echo strpos($_SERVER['PHP_SELF'], '/admin/categories/') !== false ? 'active' : ''; ?>">
                            <i class="fas fa-tags"></i> Kategori
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo SITE_URL; ?>admin/orders/" class="<?php echo strpos($_SERVER['PHP_SELF'], '/admin/orders/') !== false ? 'active' : ''; ?>">
                            <i class="fas fa-shopping-cart"></i> Pesanan
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo SITE_URL; ?>admin/users/" class="<?php echo strpos($_SERVER['PHP_SELF'], '/admin/users/') !== false ? 'active' : ''; ?>">
                            <i class="fas fa-users"></i> Pengguna
                        </a>
                    </li>
                    <!-- Logout button section tepat di bawah menu pengguna -->
                    <li>
                        <a href="<?php echo SITE_URL; ?>admin/logout-button.php" class="logout-btn">
                            <i class="fas fa-sign-out-alt"></i> Logout
                        </a>
                    </li>
                </ul>
            </div>
            <div class="sidebar-footer">
            </div>
        </div>
        <div class="admin-content">
            <div class="admin-top-header">
                <div class="header-actions">
                    <span class="admin-name">Selamat datang, <?php echo $_SESSION['admin_name'] ?? 'Admin'; ?></span>
                    
                </div>
            </div> 